var POImap = {};

POImap.init = function(groupCheckboxes) {
  var attr_osm = 'Map &copy; <a href="//openstreetmap.org/">OpenStreetMap</a> contributors',
    attr_overpass = 'data via <a href="//overpass-api.de/">Overpass API</a>';

  var osm = new L.TileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: [attr_osm, attr_overpass].join(' &mdash; ')
    }),
    positron = new L.tileLayer('https://cartodb-basemaps-{s}.global.ssl.fastly.net/light_all/{z}/{x}/{y}@2x.png', {
      attribution: ['Map tiles &copy; <a href="http://cartodb.com/attributions">CartoDB</a>', attr_osm, attr_overpass].join(' &mdash; '),
      maxzoom: 19
    }),
    Hydda_Full = L.tileLayer('https://{s}.tile.openstreetmap.se/hydda/full/{z}/{x}/{y}.png', {
      attribution: ['Tiles courtesy of <a href="http://openstreetmap.se/" target="_blank">OpenStreetMap Sweden</a>', attr_osm, attr_overpass].join(' &mdash; '),
    }),
    transport = new L.tileLayer('https://{s}.tile.thunderforest.com/transport/{z}/{x}/{y}.png?apikey=38175149cbe84e19b4d6bc30da71082d', {
      attribution: ['Transport Map &copy; <a href="http://www.thunderforest.com/maps/transport/">Thunderforest</a>', attr_osm, attr_overpass].join(' &mdash; '),
      maxzoom: 22
    }),
    transportdark = new L.tileLayer('https://{s}.tile.thunderforest.com/transport-dark/{z}/{x}/{y}.png?apikey=38175149cbe84e19b4d6bc30da71082d', {
      attribution: ['Transport Map &copy; <a href="https://www.thunderforest.com/maps/transport-dark/">Thunderforest</a>', attr_osm, attr_overpass].join(' &mdash; '),
      maxzoom: 22
    }),
    oepnvkarte = new L.tileLayer('https://tileserver.memomaps.de/tilegen/{z}/{x}/{y}.png', {
      attribution: ['ÖPNVKarte Map &copy; <a href="http://memomaps.de/">Melchior Moos</a>', attr_osm, attr_overpass].join(' &mdash; '),
      maxzoom: 19
    });

  ;


  map = new L.Map('map', {
    center: new L.LatLng(49.615, 6.14),
    zoom: 13,
    layers: positron,
    fullscreenControl: true,
    fullscreenControlOptions: {
      position: 'topleft'
    }
  })


  map.getControl = function() {
    var ctrl = new L.Control.GroupedLayers({
      'OpenSteetMap': osm,
      'OSM Positron': positron,
      'OSM Sweden Hydda': Hydda_Full,
      'Thunderforest Transport': transport,
      'Thunderforest Transport Dark': transportdark,
      'ÖPNVKarte': oepnvkarte
    }, null, {
      sortLayers: true,
      groupCheckboxes: groupCheckboxes
    });
    return function() {
      return ctrl;
    };
  }();

  map.addControl(map.getControl());

  // var path_style = L.Path.prototype._updateStyle;
  // L.Path.prototype._updateStyle = function() {
  //     path_style.apply(this);
  //     for (var k in this.options.svg) {
  //         this._path.setAttribute(k, this.options.svg[k]);
  //     }
  // };

  POImap.map = map;
  return map;
};


POImap.loadAndParseOverpassJSON = function(url, callbackNode, callbackWay, callbackRelation, callbackSuccess) {
  $.getJSON(url, function(json) {
    POImap.parseOverpassJSON(json, callbackNode, callbackWay, callbackRelation);
    if (typeof callbackSuccess === 'function') callbackSuccess();
  });
};

POImap.parseOverpassJSON = function(overpassJSON, callbackNode, callbackWay, callbackRelation) {
  var nodes = {},
    ways = {};
  for (var i = 0; i < overpassJSON.elements.length; i++) {
    var p = overpassJSON.elements[i];
    switch (p.type) {
      case 'node':
        p.coordinates = [p.lon, p.lat];
        p.geometry = {
          type: 'Point',
          coordinates: p.coordinates
        };
        nodes[p.id] = p;
        // p has type=node, id, lat, lon, tags={k:v}, coordinates=[lon,lat], geometry
        if (typeof callbackNode === 'function') callbackNode(p);
        break;
      case 'way':
        p.coordinates = p.nodes.map(function(id) {
          return nodes[id].coordinates;
        });
        p.geometry = {
          type: 'LineString',
          coordinates: p.coordinates
        };
        ways[p.id] = p;
        // p has type=way, id, tags={k:v}, nodes=[id], coordinates=[[lon,lat]], geometry
        if (typeof callbackWay === 'function') callbackWay(p);
        break;
      case 'relation':
        if (!p.members) {
          console.log('Empty relation', p);
          break;
        }
        p.members.map(function(mem) {
          mem.obj = (mem.type == 'way' ? ways : nodes)[mem.ref];
        });
        // p has type=relaton, id, tags={k:v}, members=[{role, obj}]
        if (typeof callbackRelation === 'function') callbackRelation(p);
        break;
    }
  }
};
