var weber = {};
weber.layers = {};
weber.halts = {};


function getParameterByName(name, url) {
  if (!url) url = window.location.href;
  name = name.replace(/[\[\]]/g, "\\$&");
  var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
    results = regex.exec(url);
  if (!results) return null;
  if (!results[2]) return '';
  return decodeURIComponent(results[2].replace(/\+/g, " "));
}

weber.init = function() {

  // query string: ?line=123&nocache

  var line = getParameterByName('line');
  var nocache = getParameterByName('nocache');

  if (nocache) {
    //var overpassUrl = 'https://api.openstreetmap.fr/oapi/interpreter?data=[out:json];(relation[network~"^(RGTR|Nightbus|Hop On Hop Off)"]PARAM(49.2,5.5,50.3,7.0);node(r)->.x;way(r);node(w););out qt body;';
    var overpassUrl = 'https://overpass-api.de/api/interpreter?data=[out:json];(relation[network~"^(RGTR|Nightbus|Hop On Hop Off)"]PARAM(49.2,5.5,50.3,7.0);node(r)->.x;way(r);node(w););out qt body;';

    if (line && line.match(/^[-A-Za-z0-9 ]*$/)) {
      var linesUrl = overpassUrl.replace(/PARAM/g, '["ref"="' + line + '"]');
    } else {
      var linesUrl = overpassUrl.replace(/PARAM/g, '');
    }
  } else { // nocache isn't defined
    // if not debug, use cache
    if (line && line.match(/^[-A-Za-z0-9 ]*$/)) {
      var linesUrl = line + '.json';
    } else {
      var linesUrl = 'buslines.json';
    }
  }

  // init map
  weber.map = POImap.init(!line);
  // init stop labels layer
  weber.layers.stopLabels = L.featureGroup().addTo(weber.map); // show on map
  weber.map.getControl().addOverlay(weber.layers.stopLabels, '<!--sort:0-->Noms des arrêts');
  // load lines from json
  POImap.loadAndParseOverpassJSON(linesUrl, null, null, weber.handleRelation, weber.zoomBounds);
};


weber.handleRelation = function(p) {
  // var stopAngles = weber.getStopAngles(p);
  p.members.filter(function(mem) {
    return mem.obj && mem.role != 'stop';
  }).map(function(mem) {
    weber.addLine({
      type: 'Feature',
      geometry: mem.obj.geometry,
      id: mem.obj.id,
      tags: mem.obj.tags,
      reltags: p.tags,
      // angle: stopAngles[mem.ref]
    });
  });
};


weber.getStopAngles = function(relation) {
  var stopAngle = {};
  var getAngleForStop = function(stop) {
    relation.members.map(function(mem) {
      if (mem.type != 'way') return;
      // index of node in way
      var idx = mem.obj.nodes.indexOf(stop);
      if (idx < 0) return;
      // take two adjacent ways
      // ignore projection and use lat/lon directly (shouldn't make a big difference as 2 nodes are rather close)
      var lonlat1 = mem.obj.coordinates[idx === 0 ? 0 : idx - 1];
      var lonlat2 = mem.obj.coordinates[idx === 0 ? 1 : idx];
      // determine in which order those two nodes are used
      var polarity;
      var idxWay = relation.members.filter(function(r) {
        return r.obj.type == 'way' && r.role != 'platform';
      }).indexOf(mem);
      if (idxWay < 0) {
        // ignore
      } else if (idxWay === 0) {
        // assumes ways in a block, i.e., w/o stops in between
        // f first node linked to next way then -1 else +1
        var nodes = relation.members[1].obj.nodes;
        if (!nodes) return;
        polarity = nodes.indexOf(mem.obj.nodes[0]) >= 0 ? 180 : 0;
      } else {
        // if first node linked to previous way then +1 else -1
        var relNodes = relation.members[idxWay - 1].obj.nodes;
        if (!relNodes) return;
        polarity = relNodes.indexOf(mem.obj.nodes[0]) >= 0 ? 0 : 180;
      }
      // compute direction, i.e., angle (with mathematical meaning: 0=horizontal, anti-clockwise)
      var angle = polarity + Math.atan2(lonlat2[1] - lonlat1[1], lonlat2[0] - lonlat1[0]) * 180 / Math.PI;
      //console.log(relation.tags.name, stop, mem.obj, idx, idx == 0 ? 0 : idx - 1, idx == 0 ? 1 : idx, lonlat1, lonlat2, idxWay, polarity, angle);
      stopAngle[stop] = Math.round(angle);
    });
  };

  var stops = relation.members.filter(function(mem) {
    return mem.type == 'node' && mem.role.match(/stop/); // && mem.obj.tags.name && mem.obj.tags.name.match(/Klinik/);
  }).map(function(mem) {
    return mem.ref;
  }).map(getAngleForStop);
  return stopAngle;
};



weber.addLine = function(geojson) {
  lineref = geojson.reltags.ref
  try {
    isWeber = geojson.reltags.operator.match(/(Weber|Zenners)/)
  } catch (err) {
    isWeber = false
  }

  if (isWeber) {
    var colour = '#' + (geojson.reltags.colour && geojson.reltags.colour.replace(/^#/, "")) || 'F0F';
    var opacity = 1;
    var svg = {};
    dashArray = null;
  } else {
    var colour = '#666',
      dashArray = '6,8';
  }
  var opacity = 0.5


  var layer = L.geoJson(geojson, {
    style: function(p) {
      // Adapt style/color
      return {
        opacity: opacity,
        color: colour,
        dashArray: dashArray,
        weight: 3
      };
    },
    pointToLayer: weber.addStop,
    onEachFeature: weber.bindPopup
  }).addTo(weber.layers[lineref] || weber.map);

  if (!weber.layers[lineref] && lineref != undefined) {
    weber.layers[lineref] = layer;
    // weber.map.getControl().addOverlay(layer, '<!--sort:9-->Ligne ' + lineref, "Lignes RGTR Weber");
    if (isWeber && geojson.reltags.network === 'RGTR') {
      weber.map.getControl().addOverlay(layer, '<!--sort:2-->Ligne ' + lineref, "Lignes RGTR Weber");
    } else if (isWeber && geojson.reltags.network === 'RGTR School') {
        weber.map.getControl().addOverlay(layer, '<!--sort:4-->Ligne ' + lineref, "Lignes RGTR scolaires Weber");
    } else if (isWeber && geojson.reltags.network === 'Nightbus') {
      weber.map.getControl().addOverlay(layer, '<!--sort:6-->' + lineref, "Nightlife Bus");
    } else if (isWeber && geojson.reltags.network === 'Hop On Hop Off') {
      weber.map.getControl().addOverlay(layer, '<!--sort:8-->' + lineref, "Hop On Hop Off");
    } else {
      weber.map.getControl().addOverlay(layer, '<!--sort:9-->Ligne ' + geojson.reltags.network + ' ' + lineref, "Autres lignes");
    }
  }
};




// Displaying of points, e.g., halts
weber.addStop = function(data, latlng) {
  try {
    isWeber = data.reltags.operator.match(/(Weber|Zenners)/)
  } catch (err) {
    isWeber = false
  }
  // Adapt handling of duplicate stations of same line
  if (data.tags && data.tags.name && data.id != 287054151 && isWeber) {
    var id = [data.reltags.ref, data.tags.name].join('/');
    if (!weber.halts[id]) {
      // Adapt css classes of halt name
      var className = [
        'leaflet-div-icon', 'L' + data.reltags.ref,
        data.tags && data.tags.name ? data.tags.name.replace(/\/| /g, '-').replace(/\(|\)/g, '').replace(/,/g, '-') : ''
      ].join(' ');
      // Add halt name as DivIcon
      L.marker(latlng, {
        icon: L.divIcon({
          className: className,
          html: data.tags.name || ''

        })
      }).addTo(weber.layers.stopLabels);
      weber.halts[id] = true;
    }
  }
  if (isWeber) {
    // Add/return halt as CircleMarker
    // If we have an angle, return semicircle at that angle
    return typeof data.angle === 'undefined' ? new L.CircleMarker(latlng, {
      fillOpacity: 1,
      weight: 0
    }).setRadius(5) : new L.SemicircleMarker(latlng, {
      fillOpacity: 1,
      weight: 0
    }).setRadius(10).setAngle(-1 * data.angle);
  }
};

weber.bindPopup = function(p, l) {
  // Adapt popup
  if (p.geometry.type == "Point") {

    l.bindPopup(
      (weber.girouette((p.reltags && p.reltags.ref ? p.reltags.ref : '000'), (p.reltags && p.reltags.colour ? p.reltags.colour : '000'))) +
      (p.tags && p.tags.name ? '&nbsp; <span style="font-weight: bold;">' + p.tags.name : 'Arrêt inconnu' + '</span><br />') +
      (p.tags && p.tags.name ? '<div><a href="http://travelplanner.mobiliteit.lu/hafas/query.exe/fn?S=' + p.tags.name + '" target="_blank">&#xBB;&nbsp;Comme&nbsp;départ</a>' +
        '<br/><a href="http://travelplanner.mobiliteit.lu/hafas/query.exe/fn?Z=' + p.tags.name + '" target="_blank">&#xBB;&nbsp;Comme&nbsp;destination</a></div>' : ''),
      maxWidth = 400,
      minWidth = 100,
      closeButton = false
    )

  }
};


weber.girouette = function(ref, colour) {
  var textColour = 'black';
  var whiteBackgroundLines = ["6B4908", "1E1C19", "009DE0", "239B89", "496733", "2259A2", "943D8A", "A22E5B"];
  if ((whiteBackgroundLines.indexOf(ref.toUpperCase()) > -1)) {
    textColour = 'white';
  }
  if (ref.match(/^NLB/)) {
    ref = 'NLB'; // trim
    textColour = 'white'; // always a dark background
  }
  return '<div class="girouette" style="background-color: #' + colour + '; color: ' + textColour + '"><div class="height_fix"></div><div class="content">' + ref + '</div></div>';
}



weber.zoomBounds = function() {
  map.fitBounds(weber.layers.stopLabels.getBounds(), {
    padding: [4, 4]
  });
  // Finally, check all group checkboxes
  $('.leaflet-control-layers-group-selector').prop('checked', true);
}
